# Gemini Memory Bank Implementation Guide (Outline)

## I. Introduction and Core Philosophy
   A. Purpose of Gemini Memory Bank
      1. Enable Gemini to retain project understanding between sessions
      2. Transform Gemini from stateless assistant into persistent development partner
      3. Ensure compatibility with KiloCode Memory Bank ecosystem
   B. The Memory Reset Challenge
      1. Gemini resets memory between sessions
      2. Leads to repetitive context explanations and inefficiency
      3. Memory Bank resolves this via structured documentation
   C. Foundational Principles
      1. Memory Bank is mission-critical and non-optional
      2. All sessions must load `.kilocode/rules/memory-bank` before any work
      3. Accuracy and completeness define effectiveness
      4. `brief.md` is the single source of truth

## II. Memory Bank Architecture
   A. Folder Location
      - Must be stored in `.kilocode/rules/memory-bank/`
      - All operations depend on this exact path
   B. File Format
      - Markdown (.md) format
      - Human-readable, version-controllable
      - Accessible by both AI and developers

## III. Core Files and Dependencies
   A. `brief.md` — Foundation (Developer-maintained)
      - Defines project purpose, scope, goals, and tech stack
      - Never edited by AI, only read and referenced
      - Default template provided if empty
   B. `product.md` — Product Vision (AI-maintained)
      - Derived from `brief.md`
      - Describes problem, solution, audience, and user experience
   C. `context.md` — Current State (AI-maintained, frequently updated)
      - Snapshot of active development state
      - Tracks current focus, recent changes, next steps, and blockers
   D. `architecture.md` — System Design (AI-maintained)
      - Technical layout, key components, and relationships
      - Must reference real file paths from the project
   E. `tech.md` — Technical Environment (AI-maintained)
      - Technologies, dependencies, and development setup
   F. Optional Files
      - `tasks.md`: Documented workflows
      - `progress.md`: Feature completion and status tracking
      - Specialized folders (e.g., `/api/`, `/testing/`, `/deployment/`)

## IV. Core Workflows
   A. Memory Bank Initialization
      - Trigger: “initialize memory bank”
      - Perform full project analysis (source, config, dependencies)
      - Create all required files based on actual findings
      - Verify accuracy with developer
   B. Regular Task Execution
      - Read all memory bank files before any work
      - Output `[Memory Bank: Active]` or `[Memory Bank: Missing]`
      - Use memory data for informed development
   C. Memory Bank Update
      - Trigger: “update memory bank” or major project changes
      - Review and refresh all files
      - Focus on `context.md`, `architecture.md`, and `tech.md`
   D. Add Task Workflow
      - Trigger: “add task” or “store this as a task”
      - Record workflow, modified files, and verification steps in `tasks.md`

## V. Behavioral Rules
   A. Always include Memory Bank status at start of each response
      - `[Memory Bank: Active]`, `[Memory Bank: Partial]`, or `[Memory Bank: Missing]`
   B. Never proceed with major work if Memory Bank is missing
   C. Always confirm understanding with brief summary
   D. Never modify `brief.md` directly
   E. Always use real file paths, not placeholders

## VI. Context Window Management
   - Memory Bank consumes tokens upfront but saves requests long-term
   - Suggest updates when window becomes full or context drifts

## VII. Error Handling and Recovery
   - Handle missing, incomplete, or inconsistent files
   - Offer to initialize or repair missing components
   - Prioritize `brief.md` as canonical source

## VIII. Integration and Compatibility
   - Fully compatible with KiloCode and its `.kilocode/rules/memory-bank/` structure
   - Uses same commands and workflows
   - Can be expanded for future Gemini-specific optimizations

## IX. Conclusion
   - Gemini Memory Bank brings persistent understanding across sessions
   - Enables high-efficiency, context-aware AI coding collaboration
